jQuery(function($){
	
	$('#numano023').rup_combo({
		source : [new Date().getFullYear(), new Date().getFullYear()-1], 
		width: 100,
		rowStriping:true,
		ordered:false,
		blank:""
	});	

	$('#id017Fase').rup_combo({
		source : "/ab03bRERAWar/ab03b17t00/comboFase",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 300,
		rowStriping:true,
		inputText:true,
		ordered:false,
		selected: $("#id017Fase").val(),
		blank:""
	});	
	
	$('#id018Tramite').rup_combo({
		source : "/ab03bRERAWar/ab03b18t00/comboTramite",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 340,
		rowStriping:true,
		inputText:true,
		ordered:false,
		parent:["id017Fase"],
		blank:""
	});
	
	$("#fecRegDesde").rup_date();
	$("#fecRegHasta").rup_date();
	
	jQuery.validator.addMethod("validacionFechas", function(value, element, params) {
		var fechaDesde=$("#fecRegDesde").val();
		var fechaHasta=$("#fecRegHasta").val();
		if(fechaDesde!=''&&fechaHasta!=''){
			fechaDesde=new Date(fechaDesde.substring(6,10),fechaDesde.substring(3,5),fechaDesde.substring(0,2));
			fechaHasta=new Date(fechaHasta.substring(6,10),fechaHasta.substring(3,5),fechaHasta.substring(0,2));
			if(fechaDesde>fechaHasta){
				return false;
			}else{
				return true;
			}
		}else{
			return true;
		}
		
	});	
	

	if(esUsuarioModificacion){
		$("#bETelematica").rup_table({
		
		url: "../ab03b23v00",
		colNames: [
			"id023",
			$.rup.i18n.app.expedientes.procesar,		           
			$.rup.i18n.app.expedientes.expediente,
			$.rup.i18n.app.expedientes.numRegistro,
			$.rup.i18n.app.expedientes.fecReg,
			$.rup.i18n.app.expedientes.numRera,
			$.rup.i18n.app.expedientes.cifNif,
			$.rup.i18n.app.expedientes.razonSocial,
			$.rup.i18n.app.expedientes.fase,
			$.rup.i18n.app.expedientes.tramite
		],
		colModel: [
			{ 	name: "id023", 
			 	label: "id023",
				align: "", 
				width: 150, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{
				width:80,
				name: "procesar", 
				label: $.rup.i18n.app.expedientes.procesar, 
				sortable:false,
				align: "center", 
				formatter:function (cellval, opts, rwd, act) {
					return ("<input type=\"button\" name=\"ver\" value="+$.rup.i18n.app.expedientes.procesar+" onclick=\"javascript:procesar('"+rwd.expRelac023+"',"+ rwd.id023 +")\" >");
				}
			},
			{ 	name: "expRelac023", 
			 	label: "expRelac023",
				align: "center", 
				width: 130, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "numreg023", 
			 	label: "numreg023",
				align: "center", 
				width: 150, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "fregistro023Str", 
			 	label: "fregistro023Str",
				align: "center", 
				width: 115, 
				fixed: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "numRera047", 
			 	label: "numRera047",
				align: "center", 
				width: 84, 
				fixed: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "remitenteId023", 
			 	label: "remitenteId023",
				align: "center", 
				width: 90, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "remitenteNom023", 
			 	label: "remitenteNom023",
				align: "", 
				width: 190, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "desc" + $.rup_utils.capitalizedLang() + "017",
				align: "", 
				width: 210, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "desc" + $.rup_utils.capitalizedLang() + "018",
				align: "", 
				width: 210,  
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			}
			
        ],

        model:"Ab03b23v00",
        usePlugins:[
        	"feedback",
        	"fluid",
        	"toolbar",
        	"formEdit",
        	"filter",
        	"report"
         	],
		primaryKey: "id023",
		sortname: "fregistro023",
		sortorder: "desc",
		loadOnStartUp: true,
		feedback:{
			config:{
				block: false
			}
		},
		createDefaultToolButtons:false,
        buttons:[],
        core:{
			operations:{
				"detalleExpediente": {
					name:	$.rup.i18n.app.expedientes.acceder,
					icon:	"rup-icon rup-icon-edit",
					enabled: function(){
						return true;
					},
					callback: function(key, options){
						bETelematica_redirigirDetalle();
					}
				}
			},
	    	showOperations:{
	    		"add": false,
	    		"edit": false,
	    		"delete": false,
	    		"clone": false
	    	}
        },
        report: {
        	buttons: [{ 
        			'id': 'reports', 
        			'i18nCaption': $.rup.i18n.app.botones.informes, 
        			right: true,
              	 	'buttons': [
        	          { i18nCaption: "XLS", css: "xls", url: "../ab03b23v00/xlsReport"},
        	          { i18nCaption: "XLSX", css: "xls", url: "../ab03b23v00/xlsxReport" },
        	          { i18nCaption: "PDF", css: "pdf", url: "../ab03b23v00/pdfReport" }
        	      ]}
        	]
        }
	}).ready(function(){
		$("#bETelematica_toolbar").rup_toolbar({buttons:[]}).addClass("clsCustomToolbar");
	});
	}else{
		$("#bETelematica").rup_table({
			url: "../ab03b23v00",
			colNames: [
				"id023",		           
				$.rup.i18n.app.expedientes.expediente,
				$.rup.i18n.app.expedientes.numRegistro,
				$.rup.i18n.app.expedientes.fecReg,
				$.rup.i18n.app.expedientes.numRera,
				$.rup.i18n.app.expedientes.cifNif,
				$.rup.i18n.app.expedientes.razonSocial,
				$.rup.i18n.app.expedientes.fase,
				$.rup.i18n.app.expedientes.tramite
			],
			colModel: [
				{ 	name: "id023", 
				 	label: "id023",
					align: "", 
					width: 150, 
					fixed: false, 
					hidden: true, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "expRelac023", 
				 	label: "expRelac023",
					align: "center", 
					width: 130, 
					fixed: false, 
					hidden: false, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "numreg023", 
				 	label: "numreg023",
					align: "center", 
					width: 150, 
					fixed: false, 
					hidden: false, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "fregistro023Str", 
				 	label: "fregistro023Str",
					align: "center", 
					width: 115, 
					fixed: false, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "numRera047", 
				 	label: "numRera047",
					align: "center", 
					width: 84, 
					fixed: false, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "remitenteId023", 
				 	label: "remitenteId023",
					align: "center", 
					width: 90, 
					fixed: false, 
					hidden: false, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "remitenteNom023", 
				 	label: "remitenteNom023",
					align: "", 
					width: 190, 
					fixed: false, 
					hidden: false, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "desc" + $.rup_utils.capitalizedLang() + "017",
					align: "", 
					width: 210, 
					fixed: false, 
					hidden: false, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "desc" + $.rup_utils.capitalizedLang() + "018",
					align: "", 
					width: 210,  
					fixed: false, 
					hidden: false, 
					resizable: true, 
					sortable: true
				}
	        ],
	
	        model:"Ab03b23v00",
	        usePlugins:[
	        	"feedback",
	        	"fluid",
	        	"toolbar",
	        	"formEdit",
	        	"filter",
	        	"report"
	         	],
			primaryKey: "id023",
			sortname: "fregistro023",
			sortorder: "desc",
			loadOnStartUp: true,
			feedback:{
				config:{
					block: false
				}
			},
			createDefaultToolButtons:false,
	        buttons:[],
	        core:{
				operations:{
					"detalleExpediente": {
						name:	$.rup.i18n.app.expedientes.acceder,
						icon:	"rup-icon rup-icon-edit",
						enabled: function(){
							return true;
						},
						callback: function(key, options){
							bETelematica_redirigirDetalle();
						}
					}
				},
		    	showOperations:{
		    		"add": false,
		    		"edit": false,
		    		"delete": false,
		    		"clone": false
		    	}
	        },
	        report: {
	        	buttons: [{ 
	        			'id': 'reports', 
	        			'i18nCaption': $.rup.i18n.app.botones.informes, 
	        			right: true,
	              	 	'buttons': [
	        	          { i18nCaption: "XLS", css: "xls", url: "../ab03b23v00/xlsReport"},
	        	          { i18nCaption: "XLSX", css: "xls", url: "../ab03b23v00/xlsxReport" },
	        	          { i18nCaption: "PDF", css: "pdf", url: "../ab03b23v00/pdfReport" }
	        	      ]}
	        	]
	        }
		}).ready(function(){
			$("#bETelematica_toolbar").rup_toolbar({buttons:[]}).addClass("clsCustomToolbar");
		});
	}
	
	$("#bETelematica_filter_form").rup_validate({
		feedback:$("#bETelematica_feedback"),
		liveCheckingErrors: false,
		rules:{
			"idProv024":{digits:true},
			"idAno024":{digits:true},
			"id024Exp":{digits:true},
			"fecRegDesde":{date:true, validacionFechas:true},
			"fecRegHasta":{date:true, validacionFechas:true}
		}
	});	
	
	$("#bETelematica").on("rupTable_beforeFilter",
		function(){
			if(ab03bUtils.form.validate($("#bETelematica_filter_form"))){	
				return true;
			} else {
				return false;
			}
		}
	);	
	
	// Deshabilitamos la edición en la tabla
	$("#bETelematica").rup_table('setGridParam',{ ondblClickRow : function(){ bETelematica_redirigirDetalle();} });
});

//Funcion limpiar
$('#bETelematica_filter_cleanLink').click(function(event){
	resetFiltro($("#bETelematica_filter_form"));
	
	//se borran los mensajes de errores que se muestran en el feedback
	$("#bETelematica_filter_form").validate().submitted = {};
	//se cierra el feedback
	$("#bETelematica_feedback").rup_feedback("close");
	
	$("#bETelematica").rup_table('filter'); 
	
	// se quitan las imagenes que marcan el error
	$(".rup-maint_validateIcon", $("#bETelematica_filter_form")).remove();
});

//Funcion que redirige al detalle de un expediente
function bETelematica_redirigirDetalle(){
		
	var idFila = $("#bETelematica").rup_grid('getGridParam', 'selrow');
	var fila =  $("#bETelematica").rup_grid('getRowData', idFila);
	
	if(fila && fila.id023){
		var pk = fila.id023;
		location.href = $.rup.CTX_PATH + "ab03b23v00/detalle/" + pk;
	}
}

function ocultar(capaAcordeon){
	$(capaAcordeon).toggle();
};



function procesar (expediente, id023){
	var urlCarga ="/ab03bRERAWar/ab03b23v00/procesar";
	waitDialog();
	
	$.rup_ajax({
    	url: urlCarga,
    	dataType: 'json',
    	data:{'expediente':expediente, 'id023':id023},
    	cache: false,
    	type: "GET",
    	contentType: 'application/json',
    	success: function (xhr, ajaxOptions) {
    		$.unblockUI();
    		url="/ab03bRERAWar/ab03b24v00/irDetalle/"+expediente;
    		window.location=url;
    	},
   		error: function (xhr, textStatus, errorThrown) {
   			$.unblockUI();
			var errorText = $.rup.rupAjaxDefaultError(xhr, textStatus, errorThrown);
			alert(errorText,"feedbackResolucion",true);
		}
    });
}
